#Proyecto 2. Gobstones

¡Ahora es tu turno de usar Gobstones! 
Construí un programa que haga que la máquina al ejecutarlo ponga 4 bolitas, 
una de cada color, en la celda actual del tablero. 
O sea, el programa debe indicar que, comenzando con el tablero inicial de la 
izquierda, la máquina produzca el tablero final de la derecha.

<center>
![Tableros inicial y final: partiendo del primero, tenés que conseguir hacer el segundo](data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAARQAAACXCAYAAADUI6S7AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAABYlAAAWJQFJUiTwAAAAB3RJTUUH4QYZFDET6lHC8gAAIABJREFUeNrtnXmUXMV97z9Vd+ue7p5FM9LMSKNdFggJCSEJmX3HJjbG2MaJFzYnhGAnxOc475y8LC/vOQ5JbAPJi/OeHeLHc/KwQccGbGMHCJvYJQRCCIRAG2iffe/uu1W9P3pmkNA2g2fUfaX6cPoIjbqn76363W/9fr/6VZXQWmsMBoNhHJCmCQwGgxEUg8FgBMVgMBhBMRgMBiMoBoPBCIrBYDCCYjAYTmZs0wSG400URSilTENUGEIIhsvSbNtGyrH7Gx9aULTWBEGA7/vGOCoIrTVCCGzbJo5jtNZYloXnebiuW9Zry+fzFItFgiAwNlOBdpNKpYiiiDiOsW0bz/NIp9NjspsPJSi+79Pf34/v+wRBQBzHpkcqbKRJpVIjfWNZFq7rkkqlyOVyx11Y4jimu7ubfD5PGIamgypUUKSUBEFAFEUjA1M6nSabzVJdXT0xgjIwMEBPTw++748Y74dxjQwTKyhSSqSUaK3RWlMsFvF9n2KxSF1dHVVVVcctvGlvbyefz49cm6Fy7ebAF0ChUCAIAsIwpL6+/pi/Q45VTLq6uvB9/6AvNSTDWACKxSIdHR0UCoXjMup1dHSQz+fLZi+2beO6LpYlE99/lmUjyvC9Sin6+vro6ekZP0HxfZ/e3l7CMCyLYZTc+DS5XI6qqjRWgr0iISSZTFXZDDMMQ7q6uoiiaEK/q7e3d0RMyoHnOmzf8hZPPPEk+zt6kQkdAKWUBH6R3Tt3UIw05bgNrTU9PT3HDFlH/VQODAyMeCbleACLhUHu+z//xE033sjt3/0eO/d34dhW4ozDsh2U381ffvPvyvagCSEoFosMDg4yUYvNtdb09vaWrZ29dIrVjzzIT1Y9yKY3N/Ltv72dd3a2ohMoJlpFPP3IA9y76kGKsSyb3SiljumljEpQhmdzyrXTQRwW2bj2Wdbv6OG2r3+dpiz86uFfMhBKZIIGHWnZ7N72Bn/9zW+x7o0tZb+ewcHBCUuoFwqFsiXrhbTwu/bwzCub+ej5F3P9jV/hwmXzePLZFwnDKDH2IoSgv6eLf/+Xf+KXT66D2CfWUE6TH86F/caCEgRB2UKdYrHAli3vsOLci1h8+iJWLD8TK86zfeduLMtKinXgxL2sevBxPv3JqxCy/Nc9PK08ERSLxbKO6vv27sXL1NLS0kJNTQ1nLV/Ktu07EjUjqQHL8Tjrgiu48UvX4glFubcvOtb3j0pQhuemy0UUxfT09dHcPA0VK7K5HI7j0NfTl5zEsNYEVHHLrTdz5qL5J3xCe6LzM8cahPL5AVzXxbZslFJks1UU80UStZ+Y1qTSaU49bSHZqhQk4Nrl6O5Ll7kjSt8vhRwe7IfbO1FoSvUhUgpO9PmxctuL66aI4xilYoQAvxjipJxECrkYmv5PRFifhIu0LItcNktndwdSSgr5IiqOyeYymB0sDYeGcorm5ib6ervo7e/Hsmw2v/MOLc1TTc3UBFPxa3lKJcFp5syaxWNPPcFZC2ey8fUN9BUVs2e1EMfJLOE2MjiBbatisk2zOWN2Az+778e88sLTrFmzjq/+yZ/hOE4i7ykpBaSJkGvbTbH0nIuZlfW59eabefnt/Xzi6muo9SQqcR6KBiHIZtLmyZ9AivkiV3/hRr7wuU8yeUoTf/pX32TJKTMTNSs4jFKKyY1TOeeCi8g4VLTNi9Hset/d3U1nZ2dZFVIIgeOUKh6VUoRhgFIJHeeFIJ3yKBSKE9ZWB67lOZLn57ouTU1NEzJqt7a2Mjg4WBHhspRyKJ+S3AWJwx6KiuMJ8W611mQymZG1PEf0QKRk1qxZyQ15DrzhIPBPEJ9cT5iYGD6YT4lPiMWrWutE3Me4CopZ21MZhpekfjBrwirHbipOUMIwTPysy7BxJ/k+pJSJSD5GUcTg4GBZa1bGq73LX1rxm9PU1PQbi7s9ng/i5s2b8Twv0Y0ahiFSyuRU4B7BQ6mvr6exsbFi3WQpJT09Pbz99tuk02ls207kAymEoK2tjZqaGjzPS+Q9SCnZt28fy5Yto7m5uXI8lNdff53LL788sckvx3F45ZVXaGxspLm5OZH3MbxlwLZt22hqaqp48c7lcpx99tlks9lEtreUkgceeIClS5cyderURAqK53n84he/oK+vjylTplSOoLiuy8qVKxPtoezatYvTTjuN+fPnJ/Yetm7dypo1axLxgLquS3V1Nel0cqfRbdsml8uRzWYTew/j5V2ZssEPoJRKdEw/fP1JSXZqrU+I/WVNxbYRFIPBYATFYDAYQTEYDEZQDAaDwQiKwWAwgmIwGIygGAwGgxEUg8FgBMVgMBhBMRgMRlAMBoPBCIrBYDCCYjAYjKAYDAYjKAaDwWAExWAwnCCCYnYqTx7l3nTJsmykNHaTJGzbYSwm86EERUhJHCX4oK2TceQYOuwqCsOyff++ndvp6BlEmsEoEXgpj22bN9JfGP0OhmMWFMt2sFTAww/+lN3tfWiMcVQ6lu2gwiLPPrOaNzZvwbGP7/lutm3z1mtruOeee3h3Xw+WZSLtihcTz+XNV1/iB9//3+zrLkyMoFiWRdueHdx///2sWnU/bd15c+h3xXsmgq7W3fzigVXce/8DvLt7P5Z9fI8Ief6Jh3nkqRfo6OoijJXplArHcV2e/PWDPP3COvbu3UM8hkhkjIJis23rFrKTmplcX4NtBpqKR6iYjrZWirFgxswZpR8e51EgWzOJcy+8hLnTp6BNmFzxaKXJVE/i0o9dxdT67JhyKGPyfaMoZN6ppzOluYVXnnwAzE7fFY8CmmfM5ZNTp/Lgw4+U5eCvRUs/ShQUWPekNh5tAoiikKUrz6Wqqgop5ZgGoDEJilKKhslTSLkOShvjSMRogySTq8aJLeIohjLkvLTWhFFsOiNRXooaspexmcyYgxalFMp4JskyDq3L3GfGXk4WPty0sRAoZUacJCEApVX5DqTSmjAwpQbJMhpB4BfH1Gcfav5QxTFN02aQTjlm0jghgY+mdIB6VU2uLKLieB5XXvPb1DY2EMcKTC1KxRMGPtfd8sdMq6+aWEEpFAvceOs3sG0XYdzZJMQ8RDLFlVdeCULiB8FxvwTLspk7fwEgUVqb4rYEEMcxC5esQMjRBzL2hzVQ1/VMiycM23bK7EGbOoOkIeXY+sz0sMFgGD8BMk1gMBiMoBgMBiMoBoPBCIrBYDAYQTEYDEZQDAaDERSDwWAExWAwGIygGAwGIygGg8EIisFgMBhBMRgMRlAMBoMRFIPBYATFYDAYjKCMK+U+//c37lApEUKUb+/Ysba3bWOl08k2GtvGPs6nMU6E3YxLU4znRSnLom1ggCiKEtmonueRj2O6e3pob28vyxk2vylaa7q7u8fNQCZQubG1pvjMM2z81a+wPC+Rm4kKQPb18VgQkPK8xIrJrl27WLJkSQUJihDMfuQR9vzFX6BlMh0fGUXUz53LuzfdxHu7dkFCBaVYLJLNZiv+Wi2lqFq7Fuvxx9EJHeG11kyaM4eaW25hyqRJifEMD8R1XQqFAkqpChIUQMYxulhM7LbVGggHBjj/vPOYfvbZiTQOpRTvvPMO69evr/zRXWuEUghAJ9SrBRBKMW3aNKY1Nib2HnK5XOUJykgDV6Wo/i+fRxfDZBiEZ1N86jWCZzeO5FEO/DNRxp3AHJAGMtddTs1fXY+sy6ITcKC6qPLo/Nw3KT66lhOB8bKZiRGUjEf1n30R1ZdPRqiTS6P9cERQDOVwrTTECh0pOMZIKQ4QonGM2A8IY0bxgUiZs72Pl6CggSguvZIwQkZxyaANlTl6DumNH1uEsUWsSqdBSQG2VHh2jCPVmAVGCEEQRARBRBTFKKURAixL4jg2nmcjpUxk6HtiCYrBMF7eo9D0+y5bOmp5assM1u1pZE9PFUEMdemYBY2dnD97Dx+duY+GTAHHUigtjikkYRjR0dHPc8+9xfPPv8WmTbvp68vjuhYtLQ0sXz6XCy9cxIIFLaTTLkIYh8QIiiHxYrKnN8v/fXkhv948g1iBa4OUkJZQCC3W7pzCi+9NYfak+dy44k0unLMbz46PKCpSCgYHfVavfoMf/OAx9uzpxPMcbNsinXbRGnbv7mTHjlYeemgtH/vYUr74xfOZNWtKoup7jKAYDAfgWIrNbXXc/vhK3umopjYNU2thS+v7IVDpfeAA73Vn+O7Ty2kbqOLaxe8cVlSEEBSLIffe+wz33PMEnuewePFCWltbGRgYQGuN0hrLkliWi9aahx5aw65dHdx22ydYsKDFdMyxBgHTBIZKw5Ka9oE0d6xezvauaqSAa5fB1y+FeCgXWptRTErrkTDEtSAfSO5bfwpPbJmBRvBBH8WyJA8++BI/+tFTeJ5Dc3Mzd955JzNmzCCKImzHZWpzI7Ys5WiEEGSzKV55ZRt33/2f7N3bhZTmTGYjKIZkuc1Sce+rC9jaUVuafdGQTcETm0ueydT6iFvOH+DSuSFBfKBXA52DDr/YNJftnbXYljpITLZs2cuPfvQUjmMBpcroLVu2sHv3bmyviss+eTW/d9OXaMi4B9VkZLMpnntuE08++TqFQpDopRlGUAwnl5hYmq3tVbz0XiNhXPIybAu++xjc9zKcOS/gG5cM8OlFRebUxUQfSGmkHNiwp451O+tGPl8SD4d/+7en8f33C+i2bdvG1772hwQh3PyHX+WPvvoVlp+xkCrXOmTSL532eOihtbS29hgvxQiKISl4tuKxjTk6BqyDakPSDng2zGkK6e6x2dEnUfrQsEaIUrXC2u1V7OtxkFIjpaCtrYf167cf5HlYlkU6nSadzvGROdN49eW1KKXRh5mAtizJjh2tbNmyjzCMwWiKERRDMvInb+7NMVi0D/vMPvtGmrueyZBXIA/z4GsNaQ+2tGVo67ORoiQcb7zxHkFwaHm/ENDf184df/sdnnxxA67rHPHaHMfizTd3lsIeoyhGUAwJMEih6fVThOrwptnZJ0FopDhypawUMOA7+FHpd0gp6OjoHxKQQ4UgigL2t3XhpbyjFptIKentzSdyFfpxC1lNExgqC4H6wEMtxPul8UKAFAIpNNYRnAStIRzsRIWFEQE5Wv2IEAJpWUghsSzriL6HUoogCEyBmxEUQ1JQGhoyBdx+NSIk+XwR3/eB0lL7lO3RMejS49tYEoQ8WHjyfQVyqhPPjtFItNI0N9eNVLsOi9OBnoZlKfKDA+zd30oUa+QHFlkKIfD9gEzGw7JMuGMExZAIoliyeGoPb3b5dA3GdHW24/v+SDJVCMF+2+Lr37ewLZ9CYBHoAI0m8gsUBrro7eziqhUFmuokSoHSMWeeORfXtcjnA6IoJo7jg7yWKIp4/vFHeOvl52nvHiSKYqJQo7UmjmOiKKKrq4elS+dQVZU6bOLWYATFUGH4keBTS/v595d2sXO3jY4P3QIjDAK25iVC9CMLeyEqghBopVBxBJHm3FMlLQ2lhcsaTSaT4rzzTuPnP19DGEaHCZM0fT099Hb3oFQ84hEN/1sYRixYMJ3586dh25YJe46AScoaKopYCZpqIz6ztJWU9A+feRUChEZHBeJCD3HkE4c+Kg6hqDn/DMkFi0pvG/6474fcfPMVVFW5R82lCFHyVuI4RimFUmpoF7yAG264jOnTJ6O1Mh1lBMWQFIqh5A8v7+TyRYMj+ZFD0RAPexFDOY0IprUIfv/jcMo0fdDuGUpp6uqy3H779UctTNNao5Q6KH8yMFDgS1+6hCuuWIbr2sY7GXdBSfjO8CcrZeszIZDSKs2gjOIadGmvJb53/R6uWdY/yuQLTGsUfOvLgiuXaQ5TckIcK5Ytm8e3v30TqZSLOsYeOFprfD/kd37nIm677WomT6455mdOIGNBSjnqPvvQORQpBft276Jn0GfWrJl4jknDVLxtoOnsaKe9u5+pU6dSna06rsvwO/e9y70/XsVAoDn/ko9zyblnEh/zYQbH0vzLV3ZxwSmT+LuHG9jfax90V0gXtMZxBJetkPzZtZoF0zVhdHSROO+8BfzkJ3/CnXf+nNWr3zjIYxneQjOOFU1NdfzBH3yCT3/67CEBOjlCHWlZtO7cyk8f+DntvXkuufJqzlu2cLwFReC5Dg/e+0Mef3EDOiyiM4385X/9BvU1GfPUVqwLqnjh6f/k3lUPgWWTq2/m+htuYOG8Gcfl+3Xsc+ff3s6iSz7H2ZMdHvrZv+Hl6jh/6bxRfT6MBF84u4vPn9XDE2/leGxjjj1dNlpoqhzF6Y1pPr40ZvEsRRBxVDE5UKyam+u4446vsHNnO08/vZENG94lCCKkhEmTsqxceQrnnnsa1dVVRFF80uyDIoQEv5vv3vGPrLz0E6yckub7//wd6r95F6dNrxs/QbFsm71bX+fVbe3ccts3+OiSU/n2f/sGz7z8Bp+6eAW2NOmYihMTabFnz042vvUOn/vKH/GZS1fwvbvu4LVXX2XWjBaq03KCjVPQtv0NOtzp/O4Xr2awr5eo0Mczzz7HJWctGPXvUUoghOZji3r5rcW976/x0aC0IFbgj3E/dK1LIVBLSwM33HDpIXmVOC4lZKPo5KqKtWyb1154ifq5Z/CxS86nrraW7l1bWf3MCyz88lXjl0OxLIud771Hc8t0anNZBosBy1ecyY7tO4iVyXpXas6kr6+XMAyYM2cOhVAzd+5M/GKenp6+45BTEbTub2P69GlEQYiQkpq6SXS2tX+oFbuxEgSxxI+GXrEk/A23A9ZaE0UxYRARBvHQKyKO1UmZfJVS0tHWQcPkeoQQRFFIU3MzbW37GY25jCkBUij6uLaFZZU27k2nM/jFdjBFPpWaPCltvhzFpDwPpRQp1wOliOLouCxwUyikkCMTMQIxVBQmxmrpJQHIF0vuiNZgW4i0B57z/s5LY2qe0n8RMUUVolAIBI6w8IRT2hnuJLRtpRVSiJE+kox+Q90xCUo65RGGxZFt8oqFPF4qhVnLXaFosC0LaVv4QYBlZfEDH6TAsuzjUO2paWhooK31DbSQCK3p6eqkblLD6BOcQ6sA1e424t0dRGveQu1sQ/sRcnI19qLZWKfPQTZPQtRkRn3SgiUkA3GR1riXnUEHW/z9DKgijrBodur4iNvEVKeOOiuDhTxphEUpTX1DPete24/SGsex2bt/L/X1k0flN4xaUOI4ZmrLdJ58ZSt79uylNuPy2utvMnPeuZV/ju7Jqidak6uuxnNd3t68mebsArZu30mqZirVucyEJxq11jTPPhV38Cc8/sxL1LkxL7+2ibMu/NTozr+2LPRAnvDZjRTv/hXBc28c/m2Ta/Cuuxzv8xdhzW4ujaZHuTdLSLYFbTwzuIlH+l+jNerDEdaQx6aJtMITNmem53BlbglL07OpEh6KEz+0j+OI+actZtUjL7Hu1fVMrc/x7No3ufLLX0Npfcww2R7LF02ft4CWhrW88Nxq3n79Zba3B9x87SIsywhKZY42ismNzXxk7hxefO4J2ra9xq6uAlesXEB1lXtccgQyXcv1X7iGn/3HL8lm0zS0nMJFK5cQHGs6xpLo3gGK//pr8n9/HxpwmpqI9u8/9D7be8nf+VOiZ9+g6n/cgL1s/rCiHWrwwuLVwnbu7nqSzf5e6uwck+1aCqowEgJ6olSuv7awlU3+bj5dvYJPV6+gWqZPeFHRKibXOJurLz+HJ55/FhUWmbH4XFaePhet4vETFLQm0g6f/dznWbN2Lfs7e7np929hemOteXIr1kNR2F6Gsy+4hEyumnf3dXL1NRcxf+5s4ihEOu7xuAiWnnc5py45i4FiSGPjFAK/CNo6SnJDQKwofO/nFP7xZ2gge/HFVJ1zDm1/8zdDfsT7b0WXgu7g5c3oP/8hme/cgnPGPPQHRMsRFhuLu/iHjl/TFvUxzW3k2qZreazzMbbnt6NRRFrhSg+JICUcfBVyX88LCOCzNSupEu4JH/4UC0XOuewqFi07h0KgaGqcjD/KM8vHlENRKsapynHx5R9HDmWAT7ZptSQhhECpCDeV4ewLLuM8KYiiiCiKjutBiWEQ4KYz1KfBLxZL13a06057+Kuepvivvx75WfU11xD39g69wSL75S8Sb32FwoubRn6XAML1Wyn+8D+w/tt1iPrqUrKWUgJ2QBW5u+sJOuIBbGFR49RwYd2FPNj2IJFWzE6fxhlVM3i+dzXdKkQisIQk1oqH+l5mntvEyqp5J4HdlPopnclRlYHiUJ8x3oJScokUwQErMQ3J8FSCoLx9NpYkrO7pp/jD/0APFkaEouvuu1H9/dgts8jd/HtUf+0GBv/5L8gfICjD7w0efhH38mV4V58zcvC6K2x+3v8y24O20qwF0Oq3cud7d9Ib9nNOzSVcN+VLNEnFW/0v0BEHQzMdpZxLvyrwaP8G5nvN1FvZkyJF+2Eqg03yw1BRSNehb/XrBNv2HOyGb9xI8O67VN30u6SWn0LcNYA+QjVb0F9gYM1bRD0DIEuZkYiYR/dtOCgRXVAFXux5iYxVz5cmfxaHIgWVRx3Gg/Kky0sd77C30GWKJIygGBLjbrs2/c9tJO4dPPjnQy//0Yfp/qtvEferI1qvBeTXb8Xf04GQEikk2/r30+n3HzRVLhB40qWgermv/cc80vsCrjh8XkkARR2yqW83fhxi1sYaQTEkAUsSv9uKDg4/C+SvXUPw1vbSYT36yIKi9nSgegdBlPIg7/a3oT0OW8xXVP280L+WQRWOhDmHxo3gphz2FDoJVISpvRqnHIrBMOE5n8KR8z0CEMdY4S4AP4pLK5pF6e/5MCgpjTjc+wWOcEpVvPoov1SBH0XmwHQjKIZEkXIPCXU+KACyKoPwnCM993QB1UN/10DadqBQmq0eriof2RGf0v/b0iFteUgOdX6EJYj7I6IgQisjKEZQDMkgirFPmY54diOyGFAABoBhn8UB0vkBxNe/hv3e69gfEJ0i8B5QbGnArcmA0sRa85GaqcguAamSWkQ9EfFgjI41WGClYl71n+O7xe20ixDblqXwaEihoq6Ivnf6mX5qPZ7tYNavGUExJCHcCSMy5y1i4Ker6d4fMDjkcegDBKM/COh45FegFQUgP/TveaAw9J7FZ84n1zK5tHG11sytbmZSlGFgoJOgLUBFigOLXuOBmJ2dW9ltbS/tct8fgQIVKOLBGBUooiDkjItmk3Zcsw3kETBJWUNFofyQusuXMXjKdPqA+AO+gB56xXFMQWl2APuAVqBvyJOpqs3QdP7peJNyI+GJ0oprGlcS74tQwcFiMvyLlVJEQUTQHlDcWaS4t0jQHhDnYwqFgMvmn8G0mnrTSUZQDMlxUUp/tPzJ53Em1xz1bUUgOvhjaGDeZy+g+dxFqANK70MVceW0pSysmX7k+RkBKix5JAf+UqUVdZks1y45l8mZ6kNONjQYQTFUsqYEEbnzFzP9T7+Alas64vs+WNamgNmXL+O0P7gKp7rqkORppGL++szfoSXbcGRR0aCj9z+nh7bq+OMLruLMaXPNDI8RFEMiQ5+Cz5Tf+y3m3HkrTkMN4jAr2g/8ibQt5n3qHD76979PdnYz6jBrzDSatOXxvz56M2fUz8aW1kHezbCXgsVIAdykbI4/v+K3uWrhCiwpTSr2GJikrKFyRSXvM+kz55NdeSp7v3M/XY+uQ+V9tFIIICsEniWpndHIwq9+ilmfOQ+kPCjUOZKo3HXWV3h073p+suM5OvJ9RLqU+tUuOFmJLQQrZ5/CjSsuZe6kJoLY1J8YQTGcAOFPiNM4idnfu42Z/QX6Vm/A39NZOkUj5bJk0Sxql36kdMqfH46sLj56mkYTqoiPTT2D35q2jG0D+3mzZxdhHCGEYJKbZXHtTCZXVVOMQoI4Mh1RdkERgqQseBBCmErqsgfforRHrC3R6tDOUEGESLnUfvKjI/vLDp8IFg17JLY1pq8MKS0anFHdyOya5hETUGhirRjUEVhDMdAHbca2MAt6jpugaHTeR+eTsc2BlhIdmn1dyhredPUTbnoPmatKxNnBwnNR/XlTj3I8BEXnA/r/4WdHXF5eecbhELy8+f2NehI88kgpEUJUfrw/3MZal9bePLWe8NV3RjalToBbi+rsLVXpao1tJzt7MF42P66toKOoVKmcL9Lzrf+XrAYdcmxFFNHT3U2qtxcVBMnLOWhN7/DOZpV9oSggEIIioIoh5LuT1NIgLYRlUbQsNm3aRGtNTSITt47j0NraysyZM4+PoAyf93o0FRNC4C1cSBCG6ITugh/HMe60aexobWXXmjXoOJlhUKFQoLa2tuze1rG+O11TQ+3VV2MtWYK0LJJKrqaG3Xv2sHfnzsTeQzqdZsqUKaN6zo/a53oUktrT00NnZ+cxj8vo2b8fmfDtIZVtE1gWSojE5mmllNTW1pJKpYiPIoqO49DY2IjjOON+Da2treTz+aMbn5RIz0NZFklORgilkGFI0vE8D9/3j3rEiZTyqJ7MqDwUrfXI62jUTZ2KTnjmWwy540k2cCklruvi+/4R+2w0/Tke4ddR/z2OUccQncR4twm/fq01juMc0y6O1afjmkNRcfJnSk6EpP3xEAuDYcIFZcJHXsvCtiyUihN/fIfjOIQngJtc2Z6ahZfysC2LKAopFv3ECq1l2zi2je8XK9p5Tkz2VAhBT8c+nnziCd7e+h7W8TikaoJIpVO8tn69eeIndPCxGejaxw/+53e59dZb+f499+OHUSKL0RzXYd97W1j1kx/TW+TI+94aQRmtmMCed9/mjjvuYsPGjaz68b/zy0dX43qpxIVT2UyGpx6+n3+6Z1Wi610q3GLwrIhV968iTtVz3fXX0bplHU+9tIE4YZ6t1oq3X3+Ff7jzTtZv2kKsRUVrokyCcfiFPBvWraX5lBXccvPNXHjOMna+vYGdrd1YiZmiFqRszV23/3deenUz7V095rmfwNC4becOOvKa5ctXsHz5Cj5x2fmse2U9YZScdTlCCHq7u3nvz5kmAAADXElEQVTh+RdZuPxc6tOy4vdikZXfqBD4Pvv27WPR6Uuorq5m1swZpDyLPftakQk6qD0KA8665Cpuvf5arATXXVR+7kTS2dVBOlNNLpdFxYrpM6fR2dH5oU7DK593oqmurePaL9/I0oXzQVe+dyVH91CLsrrnSikKfoFsNkesYmzHwbIsgmKQoFoRTSw8Tl90KjW5zAm/FrHc4ZxSqmS3Q6GmlBKlVeLaUUpJJpPFliIRlQwyCcYhpMC1PXy/WDoAPI7RSmO7diIN5GSY0C2nB6a1piZXje8XCcIAKSXdnb3U1FQjZfKkXB903uEJICi2bZdt8ZMGHMdl8uR6tm7bhm3bdHZ2kc8XmNLQkCgX9mSiqqqqbANRHMdMm/MR9GA7GzZupr+vl4d//SinnroAyzJbAE2k5zkqQXFdd6SKrgzDDemqDIvPPJMXH1nFd+64i1UPPkx181zmzZhCFCdNUEptWAm5H9u2J+yhT6fTx1yqMXFNrAhFmi9/8fNsefVJrr/+ejrlFD5x6Tk4djJzV1LIUn+V+ToymczRBUePUiW6u7vp7u4u64O4f/e7rHt1I9Nnz2fJ4oUIHScwfBBY0SC/eGotn7zi4gkRaSEEqVSKIAiOuJZHKUVjYyO5XG7C7rSvr4+Ojo4yjqYS27GRQpSOyIjCxK6okFJiWRZRGE6IzWutyWQyBEFwxLU8lmXR0tJy1HB21IISBAEdHR0UCoWyubLDjaqUOuqitySIimNbEzaFeSxBGTaehoaGCQ9l9+/ff8xFgoYK8JuPIShCCBoaGo45AI3aJ3Vdl9raWjzPK9tNK6UIwzDhYlLytspZD+F5HpMmTTouebHGxkbS6XQyNn0yHHEgr6mpGZU3OyaLGk60dXd34/v+yNScoTJHnOHX8MMspRwRE9c9PksXhBA0NzfT0dFBPp8njmOTSK9wexm2GSlLeZva2lqy2ezo+lt/iGEjiiJ6e3spFosngLdw4iGEwPM8giAYEX0pJVVVVVRXV5dtSjcIAvr7+wkSuBPeyYDneURRRBzHSClJpVLkcrkxJdc/lKAME8cxfsI3VDqR3dQDRxvP88o362I4eQYzbQJbg8EwXgOZaQKDwWAExWAwGEExGAxGUAwGg8EIisFgMIJiMBgSyP8H/I2pOGX+qYgAAAAASUVORK5CYII=)
</center>

Explorá el entorno para descubrir cómo agregar comandos primitivos a un programa 
y cómo ejecutar ese programa. Son varias cosas a descubrir. 
Estos descubrimientos te van a permitir hacer cosas muy interesantes. 
(Te damos una pista: ¡mirá la “caja de herramientas” que está a la izquierda!)

<center>
![Caja de herramientas](data:image/png;base64,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)
</center>

> **Para tener en cuenta**
>
> Los colores de las bolitas en Gobstones son `Azul`, `Negro`, `Rojo` y `Verde`. 
> Llamamos tablero  inicial al tablero en el que la máquina empieza a ejecutar el programa. 
> Y al tablero que la máquina deja cuando termina de ejecutar el programa lo llamamos tablero final. 
> La celda actual es la celda que el cabezal tiene justo debajo, y es la única en la que puede 
> realizar acciones en cada momento.

.

> **Cuestión de argumento**
>
> El comando primitivo `Poner` tiene un _agujero_. 
> En ese agujero hay que poner un color. 
> Al valor que ponés en el agujero se lo llama **argumento**. 
> Por ejemplo, `Rojo` es el argumento en `Poner(Rojo)`.

[Enunciado en PDF][PDF]

[PDF]: https://raw.githubusercontent.com/gobstones/curso-InPr-UNQ/master/Proyectos/1.Descubrir%20Gobstones/2.Gobstones/assets/resources/description.pdf "Enunciado de 'Gobstones' en PDF"
